﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class WebSettingsDB
    {
        public static WebSettings GetItem(Guid settingsID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@SettingsID", ((settingsID != Guid.Empty && settingsID != null) ? settingsID : (object)DBNull.Value)));
            return SQLHelper.RetrieveObject<WebSettings>("spGetSettings", parameters);
        }

        public static List<WebSettings> GetList(Guid settingsID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@SettingsID", ((settingsID != Guid.Empty && settingsID != null) ? settingsID : (object)DBNull.Value)));
            return SQLHelper.RetrieveList<WebSettings>("spGetSettings", parameters);
        }

        public static DataTable GetDataTable(Guid settingsID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@SettingsID", ((settingsID != Guid.Empty && settingsID != null) ? settingsID : (object)DBNull.Value)));
            return SQLHelper.ExecuteDataTable("spGetSettings", parameters);
        }

        public static DataSet GetDataSet(Guid settingsID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@SettingsID", ((settingsID != Guid.Empty && settingsID != null) ? settingsID : (object)DBNull.Value)));
            return SQLHelper.ExecuteDataSet("spGetSettings", parameters);
        }

        public static void Save(WebSettings myWebSettings)
        {
            myWebSettings.Mode = ((myWebSettings.UniqueID != Guid.Empty && myWebSettings.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myWebSettings.UniqueID = ((myWebSettings.UniqueID != Guid.Empty && myWebSettings.UniqueID != null) ? myWebSettings.UniqueID : Guid.NewGuid());
            if (myWebSettings.Mode == GlobalConfigurations.Mode.Insert)
            {
                myWebSettings.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@SettingsID", myWebSettings.UniqueID));
            parameters.Add(new SqlParameter("@SMTPserver", (string.IsNullOrEmpty(myWebSettings.SMTPserver) ? (object)DBNull.Value : myWebSettings.SMTPserver)));
            parameters.Add(new SqlParameter("@SMTPUserName", (string.IsNullOrEmpty(myWebSettings.SMTPUserName) ? (object)DBNull.Value : myWebSettings.SMTPUserName)));
            parameters.Add(new SqlParameter("@SMTPpassword", (string.IsNullOrEmpty(myWebSettings.SMTPpassword) ? (object)DBNull.Value : myWebSettings.SMTPpassword)));
            parameters.Add(new SqlParameter("@SMTPPort", (myWebSettings.SMTPPort == 0 ? (object)DBNull.Value : myWebSettings.SMTPPort)));
            parameters.Add(new SqlParameter("@ContactEmailAddress", (string.IsNullOrEmpty(myWebSettings.ContactEmailAddress) ? (object)DBNull.Value : myWebSettings.ContactEmailAddress)));
            parameters.Add(new SqlParameter("@SalesEmailAddress", (string.IsNullOrEmpty(myWebSettings.SalesEmailAddress) ? (object)DBNull.Value : myWebSettings.SalesEmailAddress)));
            parameters.Add(new SqlParameter("@FromEmailAddress", (string.IsNullOrEmpty(myWebSettings.FromEmailAddress) ? (object)DBNull.Value : myWebSettings.FromEmailAddress)));
            parameters.Add(new SqlParameter("@ToEmailAddress", (string.IsNullOrEmpty(myWebSettings.ToEmailAddress) ? (object)DBNull.Value : myWebSettings.ToEmailAddress)));
            parameters.Add(new SqlParameter("@CCEmailAddress", (string.IsNullOrEmpty(myWebSettings.CCEmailAddress) ? (object)DBNull.Value : myWebSettings.CCEmailAddress)));
            parameters.Add(new SqlParameter("@BCCEmailAddress", (string.IsNullOrEmpty(myWebSettings.BCCEmailAddress) ? (object)DBNull.Value : myWebSettings.BCCEmailAddress)));
            parameters.Add(new SqlParameter("@CompanyAddress", (string.IsNullOrEmpty(myWebSettings.CompanyAddress) ? (object)DBNull.Value : myWebSettings.CompanyAddress)));
            parameters.Add(new SqlParameter("@CompanyFullName", (string.IsNullOrEmpty(myWebSettings.CompanyFullName) ? (object)DBNull.Value : myWebSettings.CompanyFullName)));
            parameters.Add(new SqlParameter("@CompanyShortName", (string.IsNullOrEmpty(myWebSettings.CompanyShortName) ? (object)DBNull.Value : myWebSettings.CompanyShortName)));

            SQLHelper.ExecuteQuery("spAddOrUpdateWebSettings", parameters);
        }
    }
}
